# [YooKassa API SDK](../home.md)

# Class: \YooKassa\Request\PersonalData\PersonalDataResponse
### Namespace: [\YooKassa\Request\PersonalData](../namespaces/yookassa-request-personaldata.md)
---
**Summary:**

Класс, представляющий модель PersonalData.

**Description:**

Информация о персональных данных

---
### Constants
* No constants found

---
### Properties
| Visibility | Name | Flag | Summary |
| ----------:| ---- | ---- | ------- |
| public | [$cancellation_details](../classes/YooKassa-Model-PersonalData-PersonalData.md#property_cancellation_details) |  | Комментарий к отмене выплаты |
| public | [$cancellationDetails](../classes/YooKassa-Model-PersonalData-PersonalData.md#property_cancellationDetails) |  | Комментарий к отмене выплаты |
| public | [$created_at](../classes/YooKassa-Model-PersonalData-PersonalData.md#property_created_at) |  | Время создания персональных данных |
| public | [$createdAt](../classes/YooKassa-Model-PersonalData-PersonalData.md#property_createdAt) |  | Время создания персональных данных |
| public | [$expires_at](../classes/YooKassa-Model-PersonalData-PersonalData.md#property_expires_at) |  | Срок жизни объекта персональных данных |
| public | [$expiresAt](../classes/YooKassa-Model-PersonalData-PersonalData.md#property_expiresAt) |  | Срок жизни объекта персональных данных |
| public | [$id](../classes/YooKassa-Model-PersonalData-PersonalData.md#property_id) |  | Идентификатор персональных данных |
| public | [$metadata](../classes/YooKassa-Model-PersonalData-PersonalData.md#property_metadata) |  | Метаданные выплаты указанные мерчантом |
| public | [$status](../classes/YooKassa-Model-PersonalData-PersonalData.md#property_status) |  | Текущий статус персональных данных |
| public | [$type](../classes/YooKassa-Model-PersonalData-PersonalData.md#property_type) |  | Тип персональных данных |

---
### Methods
| Visibility | Name | Flag | Summary |
| ----------:| ---- | ---- | ------- |
| public | [__construct()](../classes/YooKassa-Common-AbstractObject.md#method___construct) |  | AbstractObject constructor. |
| public | [__get()](../classes/YooKassa-Common-AbstractObject.md#method___get) |  | Возвращает значение свойства |
| public | [__isset()](../classes/YooKassa-Common-AbstractObject.md#method___isset) |  | Проверяет наличие свойства |
| public | [__set()](../classes/YooKassa-Common-AbstractObject.md#method___set) |  | Устанавливает значение свойства |
| public | [__unset()](../classes/YooKassa-Common-AbstractObject.md#method___unset) |  | Удаляет свойство |
| public | [fromArray()](../classes/YooKassa-Common-AbstractObject.md#method_fromArray) |  | Устанавливает значения свойств текущего объекта из массива |
| public | [getCancellationDetails()](../classes/YooKassa-Model-PersonalData-PersonalData.md#method_getCancellationDetails) |  | Возвращает cancellation_details. |
| public | [getCreatedAt()](../classes/YooKassa-Model-PersonalData-PersonalData.md#method_getCreatedAt) |  | Возвращает created_at. |
| public | [getExpiresAt()](../classes/YooKassa-Model-PersonalData-PersonalData.md#method_getExpiresAt) |  | Возвращает срок жизни объекта персональных данных. |
| public | [getId()](../classes/YooKassa-Model-PersonalData-PersonalData.md#method_getId) |  | Возвращает id. |
| public | [getMetadata()](../classes/YooKassa-Model-PersonalData-PersonalData.md#method_getMetadata) |  | Возвращает любые дополнительные данные. |
| public | [getStatus()](../classes/YooKassa-Model-PersonalData-PersonalData.md#method_getStatus) |  | Возвращает статус персональных данных. |
| public | [getType()](../classes/YooKassa-Model-PersonalData-PersonalData.md#method_getType) |  | Возвращает тип персональных данных. |
| public | [jsonSerialize()](../classes/YooKassa-Common-AbstractObject.md#method_jsonSerialize) |  | Возвращает ассоциативный массив со свойствами текущего объекта для его дальнейшей JSON сериализации |
| public | [offsetExists()](../classes/YooKassa-Common-AbstractObject.md#method_offsetExists) |  | Проверяет наличие свойства |
| public | [offsetGet()](../classes/YooKassa-Common-AbstractObject.md#method_offsetGet) |  | Возвращает значение свойства |
| public | [offsetSet()](../classes/YooKassa-Common-AbstractObject.md#method_offsetSet) |  | Устанавливает значение свойства |
| public | [offsetUnset()](../classes/YooKassa-Common-AbstractObject.md#method_offsetUnset) |  | Удаляет свойство |
| public | [setCancellationDetails()](../classes/YooKassa-Model-PersonalData-PersonalData.md#method_setCancellationDetails) |  | Устанавливает cancellation_details. |
| public | [setCreatedAt()](../classes/YooKassa-Model-PersonalData-PersonalData.md#method_setCreatedAt) |  | Устанавливает время создания персональных данных. |
| public | [setExpiresAt()](../classes/YooKassa-Model-PersonalData-PersonalData.md#method_setExpiresAt) |  | Устанавливает срок жизни объекта персональных данных. |
| public | [setId()](../classes/YooKassa-Model-PersonalData-PersonalData.md#method_setId) |  | Устанавливает id. |
| public | [setMetadata()](../classes/YooKassa-Model-PersonalData-PersonalData.md#method_setMetadata) |  | Устанавливает любые дополнительные данные. |
| public | [setStatus()](../classes/YooKassa-Model-PersonalData-PersonalData.md#method_setStatus) |  | Устанавливает статус персональных данных. |
| public | [setType()](../classes/YooKassa-Model-PersonalData-PersonalData.md#method_setType) |  | Устанавливает тип персональных данных. |
| public | [toArray()](../classes/YooKassa-Common-AbstractObject.md#method_toArray) |  | Возвращает ассоциативный массив со свойствами текущего объекта для его дальнейшей JSON сериализации Является алиасом метода AbstractObject::jsonSerialize() |
| protected | [getUnknownProperties()](../classes/YooKassa-Common-AbstractObject.md#method_getUnknownProperties) |  | Возвращает массив свойств которые не существуют, но были заданы у объекта |

---
### Details
* File: [lib/Request/PersonalData/PersonalDataResponse.php](../../lib/Request/PersonalData/PersonalDataResponse.php)
* Package: YooKassa\Model
* Class Hierarchy:  
  * [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)
  * [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)
  * \YooKassa\Request\PersonalData\PersonalDataResponse

---
### Tags
| Tag | Version | Description |
| --- | ------- | ----------- |
| author |  | cms@yoomoney.ru |

---
## Properties
<a name="property_cancellation_details"></a>
#### public $cancellation_details : \YooKassa\Model\PersonalData\PersonalDataCancellationDetails
---
***Description***

Комментарий к отмене выплаты

**Type:** <a href="../classes/YooKassa-Model-PersonalData-PersonalDataCancellationDetails.html"><abbr title="\YooKassa\Model\PersonalData\PersonalDataCancellationDetails">PersonalDataCancellationDetails</abbr></a>

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)


<a name="property_cancellationDetails"></a>
#### public $cancellationDetails : \YooKassa\Model\PersonalData\PersonalDataCancellationDetails
---
***Description***

Комментарий к отмене выплаты

**Type:** <a href="../classes/YooKassa-Model-PersonalData-PersonalDataCancellationDetails.html"><abbr title="\YooKassa\Model\PersonalData\PersonalDataCancellationDetails">PersonalDataCancellationDetails</abbr></a>

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)


<a name="property_created_at"></a>
#### public $created_at : \DateTime
---
***Description***

Время создания персональных данных

**Type:** \DateTime

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)


<a name="property_createdAt"></a>
#### public $createdAt : \DateTime
---
***Description***

Время создания персональных данных

**Type:** \DateTime

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)


<a name="property_expires_at"></a>
#### public $expires_at : \DateTime|null
---
***Description***

Срок жизни объекта персональных данных

**Type:** <a href="../\DateTime|null"><abbr title="\DateTime|null">DateTime|null</abbr></a>

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)


<a name="property_expiresAt"></a>
#### public $expiresAt : \DateTime|null
---
***Description***

Срок жизни объекта персональных данных

**Type:** <a href="../\DateTime|null"><abbr title="\DateTime|null">DateTime|null</abbr></a>

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)


<a name="property_id"></a>
#### public $id : string
---
***Description***

Идентификатор персональных данных

**Type:** <a href="../string"><abbr title="string">string</abbr></a>

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)


<a name="property_metadata"></a>
#### public $metadata : \YooKassa\Model\Metadata
---
***Description***

Метаданные выплаты указанные мерчантом

**Type:** <a href="../classes/YooKassa-Model-Metadata.html"><abbr title="\YooKassa\Model\Metadata">Metadata</abbr></a>

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)


<a name="property_status"></a>
#### public $status : string
---
***Description***

Текущий статус персональных данных

**Type:** <a href="../string"><abbr title="string">string</abbr></a>

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)


<a name="property_type"></a>
#### public $type : string
---
***Description***

Тип персональных данных

**Type:** <a href="../string"><abbr title="string">string</abbr></a>

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)



---
## Methods
<a name="method___construct" class="anchor"></a>
#### public __construct() : mixed

```php
public __construct(array $data = array()) : mixed
```

**Summary**

AbstractObject constructor.

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">array</code> | data  |  |

**Returns:** mixed - 


<a name="method___get" class="anchor"></a>
#### public __get() : mixed

```php
public __get(string $propertyName) : mixed
```

**Summary**

Возвращает значение свойства

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | propertyName  | Имя свойства |

**Returns:** mixed - Значение свойства


<a name="method___isset" class="anchor"></a>
#### public __isset() : bool

```php
public __isset(string $propertyName) : bool
```

**Summary**

Проверяет наличие свойства

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | propertyName  | Имя проверяемого свойства |

**Returns:** bool - True если свойство имеется, false если нет


<a name="method___set" class="anchor"></a>
#### public __set() : mixed

```php
public __set(string $propertyName, mixed $value) : mixed
```

**Summary**

Устанавливает значение свойства

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | propertyName  | Имя свойства |
| <code lang="php">mixed</code> | value  | Значение свойства |

**Returns:** mixed - 


<a name="method___unset" class="anchor"></a>
#### public __unset() : mixed

```php
public __unset(string $propertyName) : mixed
```

**Summary**

Удаляет свойство

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | propertyName  | Имя удаляемого свойства |

**Returns:** mixed - 


<a name="method_fromArray" class="anchor"></a>
#### public fromArray() : mixed

```php
public fromArray(array|\Traversable $sourceArray) : mixed
```

**Summary**

Устанавливает значения свойств текущего объекта из массива

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">array OR \Traversable</code> | sourceArray  | Ассоциативный массив с настройками |

**Returns:** mixed - 


<a name="method_getCancellationDetails" class="anchor"></a>
#### public getCancellationDetails() : \YooKassa\Model\PersonalData\PersonalDataCancellationDetails|null

```php
public getCancellationDetails() : \YooKassa\Model\PersonalData\PersonalDataCancellationDetails|null
```

**Summary**

Возвращает cancellation_details.

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)

**Returns:** \YooKassa\Model\PersonalData\PersonalDataCancellationDetails|null - 


<a name="method_getCreatedAt" class="anchor"></a>
#### public getCreatedAt() : \DateTime

```php
public getCreatedAt() : \DateTime
```

**Summary**

Возвращает created_at.

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)

**Returns:** \DateTime - 


<a name="method_getExpiresAt" class="anchor"></a>
#### public getExpiresAt() : \DateTime|null

```php
public getExpiresAt() : \DateTime|null
```

**Summary**

Возвращает срок жизни объекта персональных данных.

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)

**Returns:** \DateTime|null - Срок жизни объекта персональных данных


<a name="method_getId" class="anchor"></a>
#### public getId() : string

```php
public getId() : string
```

**Summary**

Возвращает id.

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)

**Returns:** string - 


<a name="method_getMetadata" class="anchor"></a>
#### public getMetadata() : array|null

```php
public getMetadata() : array|null
```

**Summary**

Возвращает любые дополнительные данные.

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)

**Returns:** array|null - Любые дополнительные данные


<a name="method_getStatus" class="anchor"></a>
#### public getStatus() : string

```php
public getStatus() : string
```

**Summary**

Возвращает статус персональных данных.

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)

**Returns:** string - Статус персональных данных


<a name="method_getType" class="anchor"></a>
#### public getType() : string

```php
public getType() : string
```

**Summary**

Возвращает тип персональных данных.

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)

**Returns:** string - Тип персональных данных


<a name="method_jsonSerialize" class="anchor"></a>
#### public jsonSerialize() : array

```php
public jsonSerialize() : array
```

**Summary**

Возвращает ассоциативный массив со свойствами текущего объекта для его дальнейшей JSON сериализации

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

**Returns:** array - Ассоциативный массив со свойствами текущего объекта


<a name="method_offsetExists" class="anchor"></a>
#### public offsetExists() : bool

```php
public offsetExists(string $offset) : bool
```

**Summary**

Проверяет наличие свойства

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | offset  | Имя проверяемого свойства |

**Returns:** bool - True если свойство имеется, false если нет


<a name="method_offsetGet" class="anchor"></a>
#### public offsetGet() : mixed

```php
public offsetGet(string $offset) : mixed
```

**Summary**

Возвращает значение свойства

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | offset  | Имя свойства |

**Returns:** mixed - Значение свойства


<a name="method_offsetSet" class="anchor"></a>
#### public offsetSet() : void

```php
public offsetSet(string $offset, mixed $value) : void
```

**Summary**

Устанавливает значение свойства

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | offset  | Имя свойства |
| <code lang="php">mixed</code> | value  | Значение свойства |

**Returns:** void - 


<a name="method_offsetUnset" class="anchor"></a>
#### public offsetUnset() : void

```php
public offsetUnset(string $offset) : void
```

**Summary**

Удаляет свойство

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | offset  | Имя удаляемого свойства |

**Returns:** void - 


<a name="method_setCancellationDetails" class="anchor"></a>
#### public setCancellationDetails() : $this

```php
public setCancellationDetails(\YooKassa\Model\PersonalData\PersonalDataCancellationDetails|array|null $cancellation_details) : $this
```

**Summary**

Устанавливает cancellation_details.

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">\YooKassa\Model\PersonalData\PersonalDataCancellationDetails OR array OR null</code> | cancellation_details  |  |

**Returns:** $this - 


<a name="method_setCreatedAt" class="anchor"></a>
#### public setCreatedAt() : $this

```php
public setCreatedAt(\DateTime|string|int $created_at) : $this
```

**Summary**

Устанавливает время создания персональных данных.

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">\DateTime OR string OR int</code> | created_at  | Время создания персональных данных |

##### Throws:
| Type | Description |
| ---- | ----------- |
| \Exception |  |

**Returns:** $this - 


<a name="method_setExpiresAt" class="anchor"></a>
#### public setExpiresAt() : $this

```php
public setExpiresAt(\DateTime|string|int|null $expires_at = null) : $this
```

**Summary**

Устанавливает срок жизни объекта персональных данных.

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">\DateTime OR string OR int OR null</code> | expires_at  | Срок жизни объекта персональных данных |

##### Throws:
| Type | Description |
| ---- | ----------- |
| \Exception |  |

**Returns:** $this - 


<a name="method_setId" class="anchor"></a>
#### public setId() : $this

```php
public setId(string $id) : $this
```

**Summary**

Устанавливает id.

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | id  | Идентификатор персональных данных, сохраненных в ЮKassa. |

**Returns:** $this - 


<a name="method_setMetadata" class="anchor"></a>
#### public setMetadata() : $this

```php
public setMetadata(\YooKassa\Model\Metadata|array|null $metadata = null) : $this
```

**Summary**

Устанавливает любые дополнительные данные.

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">\YooKassa\Model\Metadata OR array OR null</code> | metadata  | Любые дополнительные данные |

**Returns:** $this - 


<a name="method_setStatus" class="anchor"></a>
#### public setStatus() : $this

```php
public setStatus(string $status) : $this
```

**Summary**

Устанавливает статус персональных данных.

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | status  | Статус персональных данных |

**Returns:** $this - 


<a name="method_setType" class="anchor"></a>
#### public setType() : $this

```php
public setType(string $type) : $this
```

**Summary**

Устанавливает тип персональных данных.

**Details:**
* Inherited From: [\YooKassa\Model\PersonalData\PersonalData](../classes/YooKassa-Model-PersonalData-PersonalData.md)

##### Parameters:
| Type | Name | Description |
| ---- | ---- | ----------- |
| <code lang="php">string</code> | type  | Тип персональных данных |

**Returns:** $this - 


<a name="method_toArray" class="anchor"></a>
#### public toArray() : array

```php
public toArray() : array
```

**Summary**

Возвращает ассоциативный массив со свойствами текущего объекта для его дальнейшей JSON сериализации
Является алиасом метода AbstractObject::jsonSerialize()

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

**Returns:** array - Ассоциативный массив со свойствами текущего объекта


<a name="method_getUnknownProperties" class="anchor"></a>
#### protected getUnknownProperties() : array

```php
protected getUnknownProperties() : array
```

**Summary**

Возвращает массив свойств которые не существуют, но были заданы у объекта

**Details:**
* Inherited From: [\YooKassa\Common\AbstractObject](../classes/YooKassa-Common-AbstractObject.md)

**Returns:** array - Ассоциативный массив с не существующими у текущего объекта свойствами



---

### Top Namespaces

* [\YooKassa](../namespaces/yookassa.md)

---

### Reports
* [Errors - 0](../reports/errors.md)
* [Markers - 1](../reports/markers.md)
* [Deprecated - 35](../reports/deprecated.md)

---

This document was automatically generated from source code comments on 2023-08-02 using [phpDocumentor](http://www.phpdoc.org/)

&copy; 2023 YooMoney